// Arquivos em C++
// Curso de Linguagem de Programao C++ PROG022.CPP - Silvio Sabino
// inserindo arquivos cabealho necessrios
#include<iostream.h>
#include<stdio.h>
#include<conio.h>
#include<ctype.h>
#include<string.h>

// definindo constantes para facilitar o entendimento
#define ALTERA 0
#define EXCLUI 1
#define LISTA  2

FILE *arq; //arquivo onde sero armazenados os dados
size_t tamanho; //varivel que guardar  o tamanho da estrutura "colaborador"

// estrutura para referenciar o registro
struct colaborador{
	int reg;		// registro na empresa
	char nome[41];  	// nome do colaborador
	char CPF[12];   	// cadastro de pessoa fsica(CPF)
};

// testa fim de arquivo e leitura
int teste_fluxo(colaborador &empr,FILE *str){
	return(!feof(str)&&fread(&empr,tamanho,1,str)==1);
}

// exibe os dados de um colaborador na tela
void exibir(colaborador c){
	cout <<c.reg<<" - "<<c.nome<<" - "<<c.CPF<<"\n";
}

// testa abertura do arquivo
int abrir(void){

	//tenta abrir o arquivo para atualizao ou cria novo arquivo
	if(!(arq=fopen("C:\\exemplo.txt","a+"))){
		cout << "Erro no abrir arquivo. Pressione qualquer tecla p/ voltar";
		getch();
		return(1);

	}
	return(0);
}

// exibe um menu na tela para que o usurio realize a escolha
char menu(void){

	// varivel esttica para identificar a primeira chamada
	static char opcao=0;

	// testando se  a primeira chamada ou o usurio encerrou a sesso
	if(opcao&&opcao!=54)fclose(arq);

	// limpando a tela
	clrscr();

	// exibindo o menu
	cout << "\nPrograma exemplo de manipulao de arquivos\n\n";
	cout << "1) Inserir\n";
	cout << "2) Consultar\n";
	cout << "3) Alterar\n";
	cout << "4) Excluir\n";
	cout << "5) Listar\n";
	cout << "6) Sair";

	// esperando a opo do usurio.
	// o programa no ir adiante enquanto o usurio no efetuar
	// uma escolha vlida
	do{
		gotoxy(1,10);
		cout << "Tecle a sua opo.";
		opcao=getch();
	}while(opcao<49||opcao>54);

	// se o usurio no deseja encerrar a sesso, abre-se o arquivo
	// e se houver erro o usurio ser avisado, voltando para o menu
	if(opcao!=54&&abrir())return(-1);

	// retornando para main()
	return opcao;
}


// inserindo um colaborador
void insere(void){

	colaborador novo;

	// solicitando a entrada de dados para o usurio
	cout << "\nInforme o registro: ";
	cin  >> novo.reg;
	cin.getline(novo.nome,40);
	cout << "\n\nInforme o nome: ";
	cin.getline(novo.nome,40);
	cout << "\nInforme o CPF: ";
	cin.getline(novo.CPF,11);

	// gravando os dados em arquivo
	fwrite((void*)&novo,tamanho,1,arq);
}


// consultando os dados armazenados
void consulta(void){
	char opcao;

	//perguntando ao usurio qual o chave de consulta desejada
	//a instruo do-while somente terminar quando a resposta for vlida
	do{
		gotoxy(1,12);
		cout << "Deseja consultar por nome, CFP ou registro (N/C/R)?";
		opcao=toupper(getch());
	}while(opcao!='N'&&opcao!='C'&&opcao!='R');

	//solicitando agora a entrada do dado a ser consultado
	//observe o uso do operador ternrio ?:
	cout <<"\n\n"<<(opcao=='N'?"Nome: ":opcao=='C'?"CPF: ":"Registro: ");
	colaborador cons,temp;
	if(opcao=='R')cin >> cons.reg;
	else cin.getline(opcao=='N'?cons.nome:cons.CPF,opcao=='N'?40:11);
	cout <<"\n";
	rewind(arq);

	//pesquisando o arquivo e exibindo os dados que satisfazem  consulta
	while(teste_fluxo(temp,arq))if(
		(opcao=='N'&&!strcmp(cons.nome,temp.nome))||
		(opcao=='C'&&!strcmp(cons.CPF,temp.CPF))||
		(opcao=='R'&&cons.reg==temp.reg)){

			exibir(temp);
	}

	//deixando o usurio decidir quando voltar ao menu
	cout <<"\nPressione qualquer tecla para voltar ao menu";
	getch();
}

//alterando, excluindo ou listando os dados gravados
void modifica(int z=ALTERA){
	int reg,opcao;
	colaborador temp;

	//como o registro  nico para cada colaborador, as operaes de
	//alterao e excluso so direcionadas por esse campo
	if(z!=LISTA){
		cout <<"\nInforme o no. do registro: ";
		cin  >>reg;
	}
	else cout <<"\n\n";

	//criando um arquivo temporrio para auxiliar as operaes de
	// alterao e excluso
	FILE *tmp=tmpfile();

	// pesquisando o arquivo e efetuando a operao desejada
	while(teste_fluxo(temp,arq)){

		// se foi pedida a listagem, ento todos os dados so exibidos
		if(z==LISTA)exibir(temp);

		//seno,  executada a ao somente no colaborador informado
		else if(temp.reg==reg){
			if(z==ALTERA){
				do{
					gotoxy(1,11);
					cout <<"\n\nAlterar nome ou CPF (N/C)?";
					opcao=toupper(getch());
				}while(opcao!='N'&&opcao!='C');

				// novamente o uso extensivo do operador ternrio ?:
				cout <<"\n"<<"Novo "<<(opcao=='N'?"nome: ":"CPF: ");
				cin.get(temp.CPF[11]);
				cin.getline(opcao=='N'?temp.nome:temp.CPF,opcao=='N'?40:11);
			}
			cout 	<<"Registro "<<(z==ALTERA?"alterado. ":"excludo. ");
		}
		if(temp.reg!=reg||z==ALTERA)fwrite(&temp,tamanho,1,tmp);
	}

	//reescrevendo os dados reorganizados no arquivo de origem
	if(z!=LISTA){
		fclose(arq);
		arq=fopen("C:\\Exemplo.txt","wb+");
		rewind(tmp);
		while(teste_fluxo(temp,tmp))fwrite(&temp,tamanho,1,arq);
	}
	// se foi pedida a lista, ento somente  impresso o caractere nova linha
	else cout <<"\n";
	fclose(tmp);
	cout <<"Pressione qualquer tecla p/ voltar.";
	getch();
}

// programa principal
void main(void){

	// obtendo o tamanho da estrutura colaborador
	// isto  til porque economiza cdigo e chamadas de funo
	tamanho=sizeof(colaborador);

	// o programa fica esperando o usurio escolher a ao
	// e direciona a ao conforme e sua opo
	for(;;)switch(menu()){
		case '1': insere();
				break;
		case '2': 	consulta();
				break;
		case '3': 	modifica();
				break;
		case '4': 	modifica(EXCLUI);
				break;
		case '5': 	modifica(LISTA);
		case  -1:	break;
		case '6': 	return;
	}
}
// fim do programa
